using System;
using System.Linq;

namespace Takmicenje
{
    class Slicice
    {
        static void Eratosten(out int[] prost, long n)
        {
            prost = new int[n + 1];

            for (long i = 0; i <= n; i++) prost[i] = 1;

            prost[0] = prost[1] = 0;

            for (long i = 2; i * i <= n; i++) {
                if (prost[i] == 1) {
                    for (long j = i * i; j <= n; j += i) prost[j] = 0;
                }
            }
        }

        static long nedostupneSlicice(long n, int[] prost) 
        { 
            long br = 1;
            long pocetak = n / 2 + 1;
            if (pocetak % 2 == 0) pocetak++;

            int[] prostDeo = new int[n - pocetak];
            Array.Copy(prost, pocetak, prostDeo, 0, n - pocetak);


            br += prostDeo.Sum(); 
     
            return br;
        }

        static void Main(string[] args)
        {

            //Korak 1 - ucitavamo q

            long q = long.Parse(Console.ReadLine());

            //Korak 2 - za svako pitanje racunamo broj razmenjivih slicica

            long N = (long)Math.Pow(10, 7);
            int[] prost;
            Eratosten(out prost, N);

            for (long i = 0; i < q; i++) {

                long n = long.Parse(Console.ReadLine());
                long nerazmenjive = nedostupneSlicice(n, prost);
                long razlicite = n - nerazmenjive;
                Console.WriteLine(razlicite);
            }
        }
    }
}